rm(list = ls())

############################################################
# perturbamos el vector un tol%

perturb <- function(x, media, dv, tol){
  p = rnorm(length(x), media, dv)
  x.p = x + p*tol*(norm(x,"2")/norm(p,"2"))
  return(x.p)
}

############################################################
# simulo los datos del ejercicio

datos = read.table("Wissel.txt", header = T, sep=";")
head(datos)
attach(datos)

reg = lm(D~C+I)
beta = as.double(reg$coefficients)

tol = 0.01
media = 10
dv = 10

Cp = perturb(C, media, dv, tol)
mean(abs(C-Cp))

Ip = perturb(I, media, dv, tol)
mean(abs(I-Ip))


reg.p = lm(D~Cp+Ip)
summary(reg.p)
beta.p = as.double(reg.p$coefficients)

(norm(C-Cp,"2")/norm(C,"2"))*100
(norm(I-Ip,"2")/norm(I,"2"))*100
(norm(beta-beta.p,"2")/norm(beta,"2"))*100

Xp = cbind(D,Cp,Ip)
write(t(Xp), "Wissel-perturbado.txt", ncolumns = 3)

detach(datos)

############################################################
# ejemplo apuntes

datos = read.table("Wissel.txt", header = T, sep=";")
datos = datos[,-1]
reg = lm(datos[,1]~datos[,2]+datos[,3])
beta = as.double(reg$coefficients)

datos.p = as.matrix(read.table("Wissel-perturbado.txt", header = F, sep=" "))
reg..p = lm(datos.p[,1]~datos.p[,2]+datos.p[,3])
summary(reg..p)
beta..p = as.double(reg..p$coefficients)

mean(abs(datos[,2]-datos.p[,2]))
mean(abs(datos[,3]-datos.p[,3]))

(norm(datos[,2]-datos.p[,2],"2")/norm(datos[,2],"2"))*100
(norm(datos[,3]-datos.p[,3],"2")/norm(datos[,3],"2"))*100
(norm(beta-beta..p,"2")/norm(beta,"2"))*100
